<?php
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => '仅支持POST请求']);
    exit;
}

$snippetName = $_POST['snippetName'] ?? '';
$jsonContent = $_POST['jsonContent'] ?? '';
$jsFile = $_FILES['jsFile'] ?? null;

// 验证输入
if (empty($snippetName) || empty($jsonContent) || !$jsFile) {
    echo json_encode(['success' => false, 'message' => '请填写所有字段']);
    exit;
}

// 验证JSON格式
json_decode($jsonContent);
if (json_last_error() !== JSON_ERROR_NONE) {
    echo json_encode(['success' => false, 'message' => 'JSON格式无效']);
    exit;
}

// 创建片段目录
$snippetDir = __DIR__ . '/../excerpt/' . $snippetName;
if (!is_dir($snippetDir)) {
    mkdir($snippetDir, 0755, true);
}

// 保存JS文件
$jsFilePath = $snippetDir . '/' . $snippetName . '.js';
if (!move_uploaded_file($jsFile['tmp_name'], $jsFilePath)) {
    echo json_encode(['success' => false, 'message' => 'JS文件上传失败']);
    exit;
}

// 保存JSON文件
$jsonFilePath = $snippetDir . '/' . $snippetName . '.json';
if (!file_put_contents($jsonFilePath, $jsonContent)) {
    echo json_encode(['success' => false, 'message' => 'JSON文件保存失败']);
    exit;
}

echo json_encode(['success' => true, 'message' => '片段上传成功']);
?>